<?php
/**
 * this is the default block template
 * Class td_block_header_15
 */
class td_block_template_15 extends td_block_template {



    /**
     * renders the CSS for each block, each template may require a different css generated by the theme
     * @return string CSS the rendered css and <style> block
     */
    function get_css() {


        // $unique_block_class - the unique class that is on the block. use this to target the specific instance via css
        $unique_block_class =  $this->get_unique_block_class();

        // the css that will be compiled by the block, <style> - will be removed by the compiler
        $raw_css = "
        <style>
            
            /* @style_general_template_15 */
            .td_block_template_15.widget > ul > li {
                margin-left: 0 !important;
            }
            .td_block_template_15 .td-related-title a {
                margin: 0 12px !important;
                font-size: 14px;
            }
            @media (max-width: 767px) {
                .td_block_template_15 .td-related-title a {
                    margin: 0 8px !important;
                }
            }
            .td_block_template_15 .td-related-title .td-cur-simple-item {
                color: #4db2ec;
            }
            .td_block_template_15 .td-block-title {
                font-size: 17px;
                font-weight: 500;
                margin-top: 0;
                margin-bottom: 26px;
                padding: 15px 0;
                line-height: 1;
                position: relative;
                overflow: hidden;
                text-align: center;
                background-color: #fff;
            }
            .td_block_template_15 .td-block-title:before {
                content: '';
                width: 100%;
                height: 2px;
                position: absolute;
                top: 0;
                left: 0;
                background-color: #4db2ec;
                z-index: 1;
            }
            .td_block_template_15 .td-block-title:after {
                content: '';
                width: 100%;
                height: 100%;
                position: absolute;
                top: 0;
                left: 0;
                border: 1px solid #ededed;
                z-index: 0;
                pointer-events: none;
            }
            .td_block_template_15 .td-block-title > * {
                margin: 0 18px;
            }
            .td_block_template_15 .td-block-title-wrap .td-wrapper-pulldown-filter {
                background-color: transparent !important;
                display: inline-block;
            }
            .td_block_template_15 .td-block-title-wrap .td-wrapper-pulldown-filter .td-pulldown-filter-display-option {
                height: 100%;
                display: table;
            }
            .td_block_template_15 .td-block-title-wrap .td-wrapper-pulldown-filter .td-pulldown-filter-display-option i {
                margin-right: 16px;
            }
            .td_block_template_15 .td-block-title-wrap .td-wrapper-pulldown-filter .td-pulldown-filter-display-option .td-pulldown-filter-list {
                border-width: 0 1px 1px;
            }
            .td_block_template_15 .td-block-title-wrap .td-wrapper-pulldown-filter .td-pulldown-filter-display-option .td-pulldown-filter-link {
                padding-right: 32px;
            }
            .td_block_template_15 .td-block-title-wrap .td-wrapper-pulldown-filter .td-pulldown-filter-display-option .td-pulldown-more {
                vertical-align: middle;
                display: table-cell;
                padding: 0;
                opacity: 0.8;
            }
            @media (max-width: 767px) {
                .td_block_template_15 .td-block-title-wrap .td-wrapper-pulldown-filter .td-pulldown-filter-display-option .td-pulldown-more span {
                    display: none;
                }
            }
            
            
            
            /* @header_text_color */
            .$unique_block_class .td-block-title > *,
            .$unique_block_class .td-pulldown-filter-display-option,
            .$unique_block_class .td-pulldown-filter-display-option i {
                color: @header_text_color !important;
            }

            /* @header_color */
            .$unique_block_class .td-block-title {
                background-color: @header_color !important;
            }

            /* @border_color */
            .$unique_block_class .td-block-title:after {
                border-color: @border_color !important;
            }

            /* @accent_text_color */
            .$unique_block_class .td_module_wrap:hover .entry-title a,
            .$unique_block_class .td_quote_on_blocks,
            .$unique_block_class .td-opacity-cat .td-post-category:hover,
            .$unique_block_class .td-opacity-read .td-read-more a:hover,
            .$unique_block_class .td-opacity-author .td-post-author-name a:hover,
            .$unique_block_class .td-instagram-user a,
            .$unique_block_class .td-pulldown-filter-item .td-cur-simple-item,
            .$unique_block_class .td-pulldown-filter-link:hover,
            .$unique_block_class .td-pulldown-filter-display-option:hover,
            .$unique_block_class .td-pulldown-filter-display-option:hover i {
                color: @accent_text_color !important;
            }

            .$unique_block_class .td-next-prev-wrap a:hover,
            .$unique_block_class .td-load-more-wrap a:hover {
                background-color: @accent_text_color !important;
                border-color: @accent_text_color !important;
            }

            .$unique_block_class .td-read-more a,
            .$unique_block_class .td-weather-information:before,
            .$unique_block_class .td-weather-week:before,
            .$unique_block_class .td-exchange-header:before,
            .td-footer-wrapper .$unique_block_class .td-post-category,
            .$unique_block_class .td-post-category:hover,
            .$unique_block_class .td-block-title:before {
                background-color: @accent_text_color !important;
            }
            
            /* @top_border_color */
            .$unique_block_class .td-block-title:before {
                background-color: @top_border_color !important;
            }
        </style>
    ";

        $td_css_compiler = new td_css_compiler(self::get_common_css() . $raw_css );

        /*-- GENERAL -- */
        $td_css_compiler->load_setting_raw( 'style_general_template_15', 1 );

        // check if we have pulldown categories for css
        $td_pull_down_items = $this->get_td_pull_down_items();
        if (!empty($td_pull_down_items)) {
            $td_css_compiler->load_setting_raw('style_general_pulldown', 1);
        }

        $td_css_compiler->load_setting_raw('header_color', $this->get_att('header_color'));
        $td_css_compiler->load_setting_raw('header_text_color', $this->get_att('header_text_color'));
        $td_css_compiler->load_setting_raw('border_color', $this->get_att('border_color'));
        $td_css_compiler->load_setting_raw('top_border_color', $this->get_att('top_border_color'));
        $td_css_compiler->load_setting_raw('accent_text_color', $this->get_att('accent_text_color'));

        $compiled_style = $td_css_compiler->compile_css();


        return $compiled_style;
    }


    /**
     * renders the block title
     * @return string HTML
     */
    function get_block_title() {

        $custom_title = $this->get_att('custom_title');
        $custom_url = $this->get_att('custom_url');
        $title_tag = 'h4';

        // title_tag used only on Title shortcode
        $block_title_tag = $this->get_att('title_tag');
        if(!empty($block_title_tag)) {
            $title_tag = $block_title_tag ;
        }

        if (empty($custom_title)) {
            $td_pull_down_items = $this->get_td_pull_down_items();
            if (empty($td_pull_down_items)) {
                //no title selected and we don't have pulldown items
                return '';
            }
            // we don't have a title selected BUT we have pull down items! we cannot render pulldown items without a block title
            $custom_title = 'Block title';
        }


        // there is a custom title
        $buffy = '';
        $buffy .= '<' . $title_tag . ' class="td-block-title">';
        if (!empty($custom_url)) {
            $buffy .= '<a href="' . esc_url($custom_url) . '">' . esc_html($custom_title) . '</a>';
        } else {
            $buffy .= '<span>' . esc_html($custom_title) . '</span>';
        }
        $buffy .= '</' . $title_tag . '>';
        return $buffy;
    }


    /**
     * renders the filter of the block
     * @return string
     */
    function get_pull_down_filter() {
        $buffy = '';

        $td_pull_down_items = $this->get_td_pull_down_items();
        if (empty($td_pull_down_items)) {
            return '';
        }

        $buffy .= '<div class="td-wrapper-pulldown-filter">';
            $buffy .= '<div class="td-pulldown-filter-display-option">';


                //show the default display value
                $buffy .= '<div id="td-pulldown-' . $this->get_block_uid() . '-val" class="td-pulldown-more"><span>';
                $buffy .=  $td_pull_down_items[0]['name'] . ' </span><i class="td-icon-menu-down"></i>';
                $buffy .= '</div>';

                //builde the dropdown
                $buffy .= '<ul class="td-pulldown-filter-list">';
                foreach ($td_pull_down_items as $item) {
                    $buffy .= '<li class="td-pulldown-filter-item"><a class="td-pulldown-filter-link" id="' . td_global::td_generate_unique_id() . '" data-td_filter_value="' . $item['id'] . '" data-td_block_id="' . $this->get_block_uid() . '" href="#">' . $item['name'] . '</a></li>';
                }
                $buffy .= '</ul>';

            $buffy .= '</div>';  // /.td-pulldown-filter-display-option
        $buffy .= '</div>';

        return $buffy;
    }
}
