<?php
/**
 * Header template
 *
 * @package Mailchimp
 */

$user         = get_option( 'mc_user' );
$is_logged_in = ! ( ! $user || ( ! get_option( 'mc_api_key' ) && ! mailchimp_sf_get_access_token() ) );
?>
<div class="mailchimp-sf-header flex items-center">
	<div class="flex items-center logo">
		<svg width="140" height="40" viewBox="0 0 140 40" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd"
				d="M27.6624 18.4598H28.5359C28.6815 18.1703 28.6815 17.5913 28.5359 16.9399C28.3903 15.9991 28.0991 15.4924 27.5896 15.4924C27.0072 15.6372 27.0072 16.2885 27.2256 17.2294C27.2984 17.736 27.5168 18.1703 27.7351 18.4598H27.6624ZM23.0762 19.1835C23.4402 19.4006 23.6586 19.473 23.8042 19.4006L23.7314 19.0388C23.513 18.7493 23.149 18.4598 22.7122 18.315C22.276 18.1296 21.7991 18.0588 21.3274 18.1095C20.8557 18.1602 20.4051 18.3307 20.0188 18.6045C19.8004 18.7493 19.5092 19.0388 19.582 19.1835L19.7276 19.2559C19.946 19.2559 20.674 18.9664 21.5475 18.894C22.1299 18.894 22.6394 19.0388 23.0034 19.1835H23.0762ZM22.2755 19.6901C21.7659 19.6901 21.5475 19.9073 21.3291 20.052L21.0379 20.4139V20.5586H21.1835L21.5475 20.4862C22.2755 20.1967 22.7122 20.2691 23.149 20.2691H23.5858V20.1244C23.513 19.9072 22.9306 19.5454 22.2755 19.6901ZM26.1336 21.2824C26.4976 21.4271 26.8616 21.4271 27.0072 21.1376C27.08 20.9205 26.9344 20.5586 26.5704 20.4139C26.2792 20.1967 25.8425 20.2691 25.7697 20.5586C25.6241 20.7757 25.7697 21.1376 26.1336 21.2824ZM28.3175 19.3283C28.0991 19.3283 27.8807 19.6901 27.8079 20.052C27.8079 20.4139 28.0263 20.7757 28.3175 20.7757C28.6087 20.7757 28.8271 20.4139 28.8271 20.052C28.8271 19.6901 28.6087 19.3283 28.3903 19.3283H28.3175ZM9.31782 26.2038C9.17223 26.2038 9.09943 26.2762 9.02663 26.2038C8.93624 26.2215 8.84291 26.2175 8.75433 26.1924C8.66575 26.1672 8.58443 26.1215 8.51706 26.059V25.1906L8.66266 25.0458C8.88104 24.5392 9.24502 23.7431 8.80825 22.8746C8.66754 22.6001 8.46119 22.3642 8.20734 22.1875C7.95349 22.0108 7.65989 21.8988 7.35233 21.8613C6.76997 21.789 6.1148 22.0061 5.75082 22.4403C5.09566 23.1641 5.02287 24.0326 5.16846 24.3944L5.31405 24.5392C5.38685 24.5392 5.60523 24.4668 5.67803 24.1773C5.67803 23.9602 5.82362 23.7431 5.96921 23.4536C6.1148 23.2365 6.33319 23.0917 6.69717 23.0193C6.98835 23.0193 7.27954 23.0193 7.49792 23.1641C7.9347 23.4536 8.08029 24.0326 7.9347 24.5392C7.8619 24.7563 7.64352 25.2629 7.71631 25.6972C7.71631 26.4933 8.29868 26.8552 8.73545 26.8552C9.17223 26.8552 9.46341 26.638 9.609 26.4933V26.2762C9.53621 26.2038 9.39061 26.2762 9.31782 26.2762V26.2038ZM35.5243 27.5065C35.1603 29.1711 34.4324 30.6186 33.1948 31.849C32.4669 32.7174 31.5205 33.4412 30.5014 33.9478L28.7543 34.6716C24.0954 36.1914 19.2908 34.5268 17.7621 30.9081C17.2341 29.6239 17.077 28.2187 17.3085 26.8506C17.54 25.4825 18.1509 24.2058 19.0725 23.1641L19.2908 22.7298L19.1452 22.368C18.4901 21.4271 16.379 19.9796 16.8158 17.0123C17.107 14.9858 18.9997 13.466 20.674 13.5383H21.1107L23.0762 13.7555C24.0954 13.7555 25.0417 13.6831 26.1336 12.7422C26.4976 12.4527 26.7888 12.1632 27.2984 12.0909H27.7351C27.9535 12.0909 28.2447 12.0909 28.4631 12.308C29.3367 12.887 29.4822 14.2621 29.4822 15.2753L29.6278 17.6637C29.6278 18.6045 29.919 18.7493 30.3558 18.894L31.3021 19.1835C32.1592 19.3413 32.9613 19.7151 33.6316 20.2691C33.85 20.5586 33.9956 20.7757 33.9956 21.0652C34.1412 22.0785 33.2676 23.2365 30.8654 24.3944C28.3529 25.5049 25.5952 25.9535 22.8578 25.6972L22.1299 25.5524C20.31 25.3353 19.3636 27.6513 20.3828 29.1711C21.1107 30.1844 22.9306 30.8357 24.7505 30.8357C29.0455 30.8357 32.2485 29.0264 33.486 27.4341L33.5588 27.2894C33.5588 27.1447 33.6316 27.217 33.5588 27.2894C32.5397 27.8684 28.0991 30.6186 23.3674 29.7501C23.3674 29.7501 22.8578 29.7501 22.3483 29.4606C21.9115 29.3159 21.0379 28.954 20.8923 28.0131C24.7505 29.1711 27.1528 28.0855 27.1528 28.0855V28.0131L27.08 27.8684C27.08 27.8684 23.9498 28.375 21.0379 27.2894C21.3291 26.2038 22.2027 26.5657 23.4402 26.7104C25.7697 26.8552 27.8807 26.4933 29.4095 26.059C30.7198 25.6972 32.4669 24.9011 33.85 23.8878C34.2868 24.8287 34.5052 25.9867 34.5052 25.9867C34.5052 25.9867 34.8691 25.9143 35.1603 26.059C35.3787 26.2762 35.5971 26.638 35.4515 27.5065H35.5243ZM13.8312 11.0052C15.2871 9.26827 17.107 7.82079 18.7085 7.02467H18.7813L18.3445 8.18266C18.3445 8.25503 18.3445 8.32741 18.4173 8.25503C19.4364 7.53129 21.1835 6.80755 22.7122 6.80755C22.7122 6.80755 22.785 6.80755 22.7122 6.87993C22.4621 7.09073 22.2417 7.33418 22.0571 7.60367H22.1299C23.2218 7.60367 24.7505 8.03791 25.7697 8.6169C25.7697 8.6169 25.7697 8.76165 25.6241 8.76165C23.6283 8.30746 21.5583 8.27902 19.5507 8.67822C17.543 9.07743 15.6433 9.8952 13.9767 11.0776C13.8312 11.0776 13.7584 11.0776 13.8312 11.0052ZM6.2604 18.9664C4.9585 19.2245 3.8093 19.9775 3.05738 21.0652C2.54995 20.6824 2.08615 20.2456 1.67426 19.7625C0.582324 17.5913 2.91179 13.3936 4.58609 11.0052C8.73545 5.21532 15.1415 0.728136 18.1989 1.52425C18.6357 1.669 20.2372 3.47835 20.2372 3.47835C20.2372 3.47835 17.3254 5.14295 14.5591 7.45892C10.7933 10.4888 7.94592 14.4971 6.33319 19.0388L6.2604 18.9664ZM8.44427 28.8816H7.8619C5.89642 28.8816 3.71254 27.0723 3.49416 24.9734C3.27577 22.6575 4.4405 20.8481 6.62437 20.4139C6.91156 20.3548 7.20487 20.3305 7.49792 20.3415C8.66266 20.3415 10.4098 21.2824 10.8465 23.9602C11.2105 26.1314 10.6281 28.5198 8.44427 28.8816ZM35.3787 24.7563L35.1603 23.8154L34.7963 22.947C35.2399 22.4011 35.4568 21.7074 35.4026 21.0077C35.3485 20.3081 35.0274 19.6555 34.5052 19.1835C33.6932 18.4758 32.718 17.9786 31.6661 17.736L30.9382 17.5913V15.1306C30.9382 14.6239 30.8654 13.8278 30.5742 12.9593C30.3259 11.9794 29.824 11.0812 29.1183 10.3539C30.9382 8.47215 32.0301 6.37331 32.0301 4.56396C32.0301 1.23475 27.8079 0.221518 22.6394 2.39274L21.5475 2.75461L19.6548 0.80051C13.7584 -4.26567 -4.65897 16.1438 1.23749 21.0652L2.47501 22.2232C2.15459 23.1529 2.05493 24.1438 2.18383 25.1182C2.3543 26.5488 3.0551 27.8648 4.14932 28.8093C5.20406 29.7792 6.57193 30.3437 8.00749 30.4015C9.202 33.008 11.1299 35.2151 13.5584 36.7562C15.9869 38.2973 18.8121 39.1066 21.6931 39.0864C28.2447 39.3035 33.85 36.1914 36.1067 30.6186C36.2523 30.2567 36.9074 28.4474 36.9074 26.9999C36.9074 25.4077 36.0339 24.7563 35.4515 24.7563H35.3787ZM133.944 23.0917C133.071 23.0917 132.343 21.9337 132.343 20.3415C132.343 18.7493 133.071 17.5189 133.944 17.5189C135.036 17.5189 135.473 18.5321 135.473 20.3415C135.473 22.1508 135.036 23.0917 134.017 23.0917H133.944ZM131.688 16.578C131.396 17.157 131.396 17.3018 131.251 17.3018C130.96 17.3018 131.178 16.8675 131.251 16.3609C131.542 15.2753 131.396 14.4792 131.396 14.4792H128.484V28.7369H132.415V24.0326C132.668 24.5284 133.053 24.9457 133.528 25.2392C134.003 25.5327 134.55 25.6911 135.109 25.6972C137.948 25.6972 139.331 23.2365 139.331 19.9073C139.331 16.2162 137.657 14.1897 135.036 14.1897C132.998 14.1897 132.124 15.7096 131.688 16.578ZM120.331 16.4333C120.113 16.9399 120.113 17.3018 119.895 17.3018C119.676 17.3018 119.822 16.8675 119.603 16.2162C119.312 15.2029 118.584 14.045 116.764 14.045C114.944 14.045 114.144 15.7096 113.78 16.578C113.489 17.157 113.489 17.3018 113.27 17.3018C113.052 17.3018 113.27 16.8675 113.416 16.2885C113.634 15.2029 113.416 14.3345 113.416 14.3345H110.504V25.5524H114.508V19.9796C114.508 18.894 114.944 17.4465 115.745 17.4465C116.619 17.4465 116.837 18.1703 116.837 19.473V25.5524H120.841V19.9796C120.841 18.9664 121.205 17.4465 122.078 17.4465C122.952 17.4465 123.098 18.4598 123.098 19.473V25.5524H127.029V18.9664C127.029 16.0714 126.009 14.1173 123.389 14.1173C121.642 14.1173 120.768 15.5648 120.331 16.4333ZM105.19 25.5524H109.194V14.4068C109.194 14.4068 108.466 14.7687 107.155 14.7687C105.845 14.7687 105.19 14.4068 105.19 14.4068V25.5524ZM107.155 10.8605C105.845 10.8605 104.68 11.5842 104.68 12.5251C104.68 13.3936 105.845 14.1173 107.155 14.1173C108.538 14.1173 109.63 13.3936 109.63 12.5251C109.63 11.5842 108.538 10.8605 107.155 10.8605ZM96.8183 16.6504C96.6727 17.0847 96.5999 17.3742 96.4544 17.3742C96.1632 17.3742 96.3816 16.8675 96.4544 16.578C96.6727 15.9991 97.0367 14.4792 97.0367 12.6698C97.0367 11.4395 96.8911 11.0052 96.8911 11.0052H93.4697V25.48H97.4007V19.9796C97.4007 19.0388 97.7647 17.5189 98.8566 17.5189C99.5846 17.5189 99.8758 18.0979 99.8758 19.4006V25.5524H103.88V19.5454C103.88 16.6504 103.443 14.045 100.24 14.045C97.9103 14.045 97.0367 16.2162 96.8911 16.6504H96.8183ZM85.899 19.9073C85.899 18.9664 86.7725 18.0255 88.5196 18.0255C89.8082 18.0606 91.0642 18.4353 92.1594 19.1111V15.2753C92.1594 15.2753 90.9947 14.1173 88.0828 14.1173C85.0982 14.1173 82.5504 15.9267 82.5504 19.7625C82.5504 23.5983 84.807 25.7695 88.0828 25.7695C90.6307 25.7695 92.1594 24.3221 92.1594 24.3221V20.7034C91.6498 20.9205 90.3395 21.8613 88.5196 21.8613C86.5541 21.8613 85.899 20.9929 85.899 19.9073ZM77.5275 25.5524H81.4584V11.0052H77.5275V25.48V25.5524ZM72.2134 25.5524H76.2171V14.4068C76.2171 14.4068 75.4892 14.7687 74.1789 14.7687C72.8685 14.7687 72.2134 14.4068 72.2134 14.4068V25.5524ZM74.2516 10.8605C72.7957 10.8605 71.7766 11.5842 71.7766 12.5251C71.7766 13.3936 72.8685 14.1173 74.1789 14.1173C75.562 14.1173 76.6539 13.3936 76.6539 12.5251C76.6539 11.5842 75.562 10.8605 74.1789 10.8605H74.2516ZM65.1522 22.8746C64.2058 23.0917 63.6963 22.8746 63.6963 22.1508C63.6963 21.2824 64.5698 20.9205 65.8801 20.9205L66.9721 20.9929C66.9721 21.3547 66.1713 22.6575 65.1522 22.8746ZM66.0985 14.1173C63.0411 14.1173 60.8572 15.2753 60.8572 15.2753V18.6045C60.8572 18.6045 63.2595 17.157 65.225 17.157C66.8265 17.157 66.9721 18.0255 66.8993 18.7493C66.8993 18.7493 66.4625 18.6045 65.0794 18.6045C61.8764 18.6045 60.2021 20.1244 60.2021 22.5127C60.2021 24.8287 62.022 25.7695 63.6235 25.7695C65.8073 25.7695 66.8993 24.2497 67.1905 23.4536C67.4089 22.947 67.4089 22.6575 67.6272 22.6575C67.8456 22.6575 67.7728 22.8746 67.7728 23.3812C67.7728 24.2497 67.7728 24.9734 67.9184 25.5524H70.903V20.052C70.903 16.578 69.7383 14.1173 66.0985 14.1173ZM52.6313 16.4333C52.3401 16.9399 52.3401 17.3018 52.1217 17.3018C51.9033 17.3018 52.1217 16.9399 51.8306 16.2162C51.6932 15.5783 51.3323 15.0098 50.8122 14.6121C50.2922 14.2143 49.6469 14.0133 48.9915 14.045C47.1716 14.045 46.3709 15.7096 46.0069 16.578C45.7157 17.157 45.7157 17.3018 45.5701 17.3018C45.2789 17.3018 45.4973 16.8675 45.5701 16.2885C45.8613 15.2029 45.6429 14.3345 45.6429 14.3345H42.7311V25.5524H46.7348V19.9796C46.7348 18.894 47.1716 17.4465 47.9724 17.4465C48.8459 17.4465 49.0643 18.1703 49.0643 19.473V25.5524H53.0681V19.9796C53.0681 18.9664 53.4321 17.4465 54.3056 17.4465C55.1792 17.4465 55.3247 18.4598 55.3247 19.5454V25.6248H59.2557V19.0388C59.2557 16.1438 58.2366 14.1897 55.6159 14.1897C53.8688 14.1897 52.9953 15.6372 52.6313 16.5057V16.4333Z"
				fill="#241C15" />
		</svg>
	</div>
	<?php if ( $is_logged_in && ! empty( $user ) && empty( $is_create_account_page ) ) : ?>
		<div class="user-profile-wrapper">
			<div class="user-profile">
				<?php
				if ( ! empty( $user['avatar_url'] ) ) {
					?>
					<div class="user-profile-avatar">
						<img src="<?php echo esc_url( $user['avatar_url'] ); ?>" alt="<?php echo esc_attr( $user['first_name'] ); ?>">
					</div>
					<?php
				}
				?>
				<div class="user-profile-details">
					<span class="user-profile-name"><?php echo esc_html( $user['first_name'] . ' ' . $user['last_name'] ); ?></span>
					<span class="user-profile-email"><?php echo esc_html( $user['email'] ); ?></span>
				</div>
			</div>
			<div class="user-profile-logout">
				<form method="post" action="" onsubmit="return confirm('<?php echo esc_js( __( 'Are you sure you want to log out?', 'mailchimp' ) ); ?>');">
					<input type="hidden" name="mcsf_action" value="logout"/>
					<input type="submit" name="submit" value="<?php esc_attr_e( 'Log out', 'mailchimp' ); ?>" class="mailchimp-sf-button btn-secondary btn-small" />
					<?php wp_nonce_field( 'mc_logout', '_mcsf_nonce_action' ); ?>
				</form>
			</div>
		</div>
	<?php endif; ?>

	<div>
		<?php if ( ! empty( $is_create_account_page ) ) : ?>
			<div class="flex items-center wizard-steps">
				<div class="step-1 <?php echo esc_attr( ( ! $signup_initiated ) ? 'current' : '' ); ?>">
					<?php esc_html_e( 'Sign up', 'mailchimp' ); ?></div>
				<span class="chevron">
					<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path fill-rule="evenodd" clip-rule="evenodd"
							d="M9.05715 8.00005L6.19522 5.13812L7.13803 4.19531L10.9428 8.00005L7.13803 11.8048L6.19522 10.862L9.05715 8.00005Z"
							fill="#241C15" fill-opacity="0.3" />
					</svg>
				</span>
				<div class="step-2 <?php echo esc_attr( ( $signup_initiated ) ? 'current' : 'deselected' ); ?>">
					<?php esc_html_e( 'Activate account', 'mailchimp' ); ?></div>
				<span class="chevron">
					<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path fill-rule="evenodd" clip-rule="evenodd"
							d="M9.05715 8.00005L6.19522 5.13812L7.13803 4.19531L10.9428 8.00005L7.13803 11.8048L6.19522 10.862L9.05715 8.00005Z"
							fill="#241C15" fill-opacity="0.3" />
					</svg>
				</span>
				<div class="step-3 deselected"><?php esc_html_e( 'Choose plan', 'mailchimp' ); ?></div>
			</div>
		<?php endif; ?>
	</div>
</div>