<?php
/**
 * @package Mobel Media
 * @version 1.0.0
 */
/*
Plugin Name: Mobel Media
Plugin URI: https://mmt.me/
Description: This is not just a plugin, just to make sure everything is working correctly on <cite>Um Nasser Finland School Website</cite>.
Author: Mazen Al-Maskati
Version: 1.0.0
Author URI: https://mmt.me/
*/

function mmt_get_msgs() {
	
	$lyrics = "Reach out to a Global Technical Team for Assistant
providing Web Solutions and Services
Hosting and web development
Web Design, Web Development, Progressive Web Apps
We believe in a simpler Web
Managing your website is part of your business experience
A Website that Works
Find the simplest choice for building your website
Start making your online presence 
Your website is now part of your business strategy
";

	// Here we split it into lines.
	$lyrics = explode( "\n", $lyrics );

	// And then randomly choose a line.
	return wptexturize( $lyrics[ mt_rand( 0, count( $lyrics ) - 1 ) ] );
}

// This just echoes the chosen line, we'll position it later.
function hello_dolly() {
	$chosen = mmt_get_msgs();
	$lang   = '';
	if ( 'en_' !== substr( get_user_locale(), 0, 3 ) ) {
		$lang = ' lang="en"';
	}

	printf(
		'<p id="dolly"><span class="screen-reader-text">%s </span><span dir="ltr"%s>%s</span></p>',
		__( 'MMT MSG:' ),
		$lang,
		$chosen
	);
}

// Now we set that function up to execute when the admin_notices action is called.
add_action( 'admin_notices', 'hello_dolly' );

// We need some CSS to position the paragraph.
function dolly_css() {
	echo "
	<style type='text/css'>
	#dolly {
		float: right;
		padding: 5px 10px;
		margin: 0;
		font-size: 12px;
		line-height: 1.6666;
	}
	.rtl #dolly {
		float: left;
	}
	.block-editor-page #dolly {
		display: none;
	}
	@media screen and (max-width: 782px) {
		#dolly,
		.rtl #dolly {
			float: none;
			padding-left: 0;
			padding-right: 0;
		}
	}
	</style>
	";
}

add_action( 'admin_head', 'dolly_css' );
